let college = {"categories":[{"type":"default","name":"Writing Format and Standards","comments":[{"abbreviation":"Heading","comment":"*Revise MLA Heading:*\nType the proper heading in the upper left-hand corner of the first page. The heading consists of the writer's full name; the instructor's title and last name; the class title; and the date.\n*Example:*\nJohn Doe\nProfessor Mark Pennington\nEnglish 101\n7 March 2021","id":"Heading0.7004074852692928"},{"abbreviation":"Header","comment":"*Revise MLA Header:*\nUsing right-justified text, type the header in the upper right-hand corner beginning on the first page, one-half inch from the top. Include your last name, followed by the page number. Each page must include your last name and page number in the header.\n*Example:* Doe 1","id":"Header0.253063184998358"},{"abbreviation":"Title","comment":"*Revise MLA Title:*\nUsing center-justified text, type, and capitalize the title. The first letter is capitalized in each word except articles (_a, an,_ or _the_), prepositions (e.g. _from, in, of_), or coordinating conjunctions (FANBOYS: _for, and, nor, but, or, yet, so_) unless it appears as the first word in the title. Do not boldface, italicize, underline, or use quotation marks for the title.\n*Example:* Walking a Mile","id":"Title0.690054805546078"},{"abbreviation":"Margin","comment":"*Revise Margins:*\nSet one-inch margins for top, bottom, left, and right except the one-half inch header. Use left-justified text and print on white 8.5 x 11-inch paper if a print submission is required.","id":"Margin0.13240227920087855"},{"abbreviation":"Spacing","comment":"*Revise Spacing:*\nSet line spacing to double space for all lines, including the header and title. Single space after all punctuation marks, including periods.","id":"Spacing0.9196625324788916"},{"abbreviation":"Citation","comment":"*Revise MLA Parenthetical (In-Text) Citations Format:*\nIn-text citations identify any outside source of information you use in your writing and must be included on a separate Works Cited page. After the direct or indirect quotation, include the following within parentheses: the author's last name (or title if none listed), followed by a space and the page number (numeral only). If the name of the author or title is used within the quotation, only the page number is included in parentheses. Place a period after the closing parenthesis.\n*Examples:*\nAs the author explains, \"Direct quotation\" (Smith 22).\nAccording to Amy Smith, \"Direct quotation\" (22).\nThe author argues that...indirect quotation (\"Article Title\" 4).\nIn _Canterbury Tales..._ indirect quotation (16).","id":"Citation0.2356394486717317"},{"abbreviation":"WrkCite","comment":"*Revise MLA Works Cited Format:*\nThe Modern Language Association (MLA) has specific rules for providing full references to parenthetical (in-text) citations. Follow these guidelines.","id":"WrkCite0.09311398906702828"},{"abbreviation":"Inc","comment":"*Incomplete:*\nYou seem to have dissected the writing prompt (assignment) and know what you need to do; however, your work is incomplete. Follow my guidelines to finish and share your best work for me, so I can help you improve your writing.","id":"Inc0.9843137043051373"},{"abbreviation":"Proof","comment":"*Needs Proofreading:*\nYour final draft should be neat and free from writing errors. Make sure to run the spelling check and edit carefully. Read through your final draft out loud to catch any errors.","id":"Proof0.9566938992433636"},{"abbreviation":"Typo","comment":"*Typographical Error:*\nSpelling error due to mistyping. The computer's spellcheck does not catch all typos. Proofread out loud to catch these errors.","id":"Typo0.9354472013282011"},{"abbreviation":"NumErr","comment":"*Number Error:*\nFor numbers zero through nine, write out numbers. For 10 and thereafter, use numbers. Keep the same format, in either written or numerical form, within the same paragraph.","id":"NumErr0.8187203155961922"},{"abbreviation":"Gap","comment":"*Close Gap:*\nThese two words should be combined as a simple compound word or as a hyphenated word. Use hyphens to join words that are necessarily related, but are not compound words. Don't capitalize the letter following the hyphen.","id":"Gap0.05739452707285464"},{"abbreviation":"Para","comment":"*Needs New Paragraph:*\nStart new paragraphs in essays for new ideas, topics, reasons, or arguments. Start new paragraphs in stories for new events, changes in place, changes in time, and for each new speaker in dialogue. Indent one tab for paragraphs. Don't add additional spacing between paragraphs. If your teacher requires block paragraph style, don't indent new paragraphs; instead, add an additional space between paragraphs.","id":"Para0.5720717074981037"},{"abbreviation":"PosForm","comment":"*Positive Format Comment:*\nYou've done an excellent job, making sure that the writing format conforms to Modern Language Association (MLA) standards.","id":"PosForm0.3504128183536408"},{"abbreviation":"PosStnd","comment":"*Positive Standards Comment:*\nYou've done a thorough job, ensuring that your final work is near error-free and up to the standards I've set for all of my students' papers. Thank you for doing your best to meet these standards.","id":"PosStnd0.600208559249582"}],"id":"Writing Format and Standards0.15705544759944612"},{"type":"default","name":"Essay Structure and Content","comments":[{"type":"text","abbreviation":"Intro","comment":"*Revise Introduction:*\nAn essay introduction provides a hook, link, and context to lead into the thesis statement. They may be separate or combined sentences.\n*▪* The first sentence of your essay is the _hook_. It grabs the attention of your reader. Choose the hook that best matches what the essay is about and your purpose for writing. Try beginning your essay with one of these *QQ SCAR* hooks: Q̲uestion, Q̲uotation, S̲tartling Statement, C̲ontroversial Statement, A̲necdote, or R̲eference to Something Known in Common.\n*Startling Statement Example:* Video games destroy lives.\n*▪* The _link_ identifies the issue or topic (if an argumentative essay) or the title and author (if an informative/explanatory essay).\n*Link Example:* According to Dr. Phoebe Caulkins, in her article titled, \"The Cost of Gaming,\" ...\n*▪* The _context_ briefly summarizesthe reading to build background knowledge for the reader. Use no more than three sentences to provide the context.\n*Context Example:* American pre-teens and teenagers spend too much time playing games on their desktops, tablets, and phones. Instead of playing outside, gamers are increasingly out of shape and score lower on standardized reading tests.","id":"Intro0.24101127881532514"},{"type":"text","abbreviation":"EvidErr","comment":"*Introducing Evidence Error:*\nDon't introduce evidence in an introduction. You may preview your topic sentences, but don't include F̲act, E̲xample, S̲tatistic, C̲omparison, Quote from an A̲uthority, L̲ogic, or E̲xperience evidence *(FE SCALE)*. Save evidence for the body paragraphs.","id":"EvidErr0.8157905849184233"},{"abbreviation":"Thesis1","comment":"*Revise Argumentative Thesis Statement:*\nYour one or two-sentence thesis statement must answer the key question you develop from the writing prompt (assignment). In an argumentative essay, your thesis statement makes a specific claim about an issue or topic, which you will argue throughout the essay. Write your thesis statement as the last sentence or two of the essay introduction, following the _hook, link,_ and _context_ sentences. Make sure to state the issue or writing topic and use the key words of the writing prompt (assignment). You may choose to preview the body paragraphs by listing key idea words from the topic sentences. Use an appropriate transition word or phrase to introduce the thesis statement.\n*Argumentative Essay Example:* However, the positive outcomes of video gaming far outweigh the negatives. Gamers develop better technological skills, increased attention spans, and superior ability to multi-task than those who do not play.","id":"Thesis10.180564613714989"},{"type":"text","abbreviation":"Thesis2","comment":"*Revise Informative/Explanatory Thesis Statement:*\nReview the writing prompt (assignment). Your one or two-sentence thesis statement must answer the key question you develop from the writing prompt (assignment). In an informative/explanatory essay, your thesis statement states the purpose for writing and serves as the controlling idea throughout the essay. Write your thesis statement as the last sentence or two of the essay introduction, following the _hook, link,_ and _context_ sentences. Make sure to state the writing topic and use the key words of the writing prompt (assignment). You may choose to preview the body paragraphs by listing key idea words from the topic sentences. Use an appropriate transition word or phrase to introduce the thesis statement.\n*Informative/Explanatory Essay Example:* Video gaming impacts young people in three ways. Gamers develop technological skills, practice sustained concentration, and learn how to multi-task.","id":"Thesis20.9079319343447312"},{"abbreviation":"TooBrd","comment":"*Broaden the Thesis Statement Focus:*\nYour thesis statement focuses too narrowly on its issue or topic. The thesis statement needs to be a bit broader to be able to respond to the demands of the writing prompt (assignment). A good thesis statement is like an umbrella: it must cover the whole subject to be effective.\n*Example:* Facial recognition software can identify a person's nose in a large crowd.\n*Revision:* Facial recognition software can identify people in a large crowd.","id":"TooBrd0.6892787768223365"},{"abbreviation":"NotImp","comment":"*Revise Unimportant Thesis Statement:*\nThe thesis statement must state a claim, if an argumentative essay, or a purpose, if an informative/explanatory essay, that is meaningful and has some degree of importance.\n*Unimportant Argumentative Thesis Statement Example:* Blue is the best color.\n*Revision:* Blue is the best color to complement a bright white background.\n*Unimportant Informative/Explanatory Thesis Statement Example:* People in France really enjoy their cheese.\n*Revision:* The French especially enjoy four types of cheeses.","id":"NotImp0.15707819916998744"},{"abbreviation":"Split","comment":"*Correct Split Thesis Statement:*\nDon't write a split (divided) thesis. A split thesis includes two claims in an argumentative essay or two purposes in an informative/explanatory essay. Focus on only one claim or purpose in your thesis statement.","id":"Split0.1449916052455602"},{"type":"text","abbreviation":"Partial","comment":"*Correct Partial Thesis Statement:*\nYour thesis statement responds to only part of the writing prompt (assignment). Re-work the key question you developed from the entire writing prompt (assignment) and revise your thesis statement to be a complete answer to this question.","id":"Partial0.3975314390499265"},{"abbreviation":"OwnRef","comment":"*Eliminate Reference to Your Own Writing:*\nDon't refer to yourself or parts of the essay.\n*Examples:* In this essay... The following paragraphs... I will prove that... The evidence will suggest that... The purpose of this essay... My point of view is that... In my opinion...","id":"OwnRef0.9251207914460515"},{"abbreviation":"RhQuest","comment":"*Eliminate the Rhetorical Question:*\nAvoid rhetorical questions in essays. A rhetorical question is a question needing no response because the answer is in the question itself.\n*Example:* Does anyone really think high speed rail is practical?\n*Revision:* High speed rail is impractical for three key reasons.","id":"RhQuest0.5692044611333744"},{"type":"text","abbreviation":"TopSent","comment":"*Needs Topic Sentence:*\nWrite a topic sentence as the first sentence of each body paragraph unless you have a reason to place it elsewhere. It usually begins with a transition word or phrase and states the main idea of the paragraph. Each topic sentence must directly respond to the thesis statement. In an argumentative essay, each topic sentence states an argument or reason. In an informative/explanatory essay, each topic sentence states a key point or a fact.\n*Example:* First, young people who play video games learn technological skills.","id":"TopSent0.9969800125581896"},{"type":"text","abbreviation":"Detail","comment":"*Needs Concrete Detail:*\nUse specific evidence from credible (believable) experts to support your topic sentences. Choose the types of evidence that will best support your topic sentences with a variety of *FE SCALE Evidence Strategies:* F̲act, E̲xample, S̲tatistic, C̲omparison, Quote from an A̲uthority, L̲ogic, or E̲xperience. In argumentative essays, be careful not to use unsupported opinions. In informative/explanatory essays, use accurate and relevant (that which directly applies) information. Use an evidence sentence starter, which includes a transition word or phrase and the source to introduce the evidence.\n*Quote from an Authority Example:* Even the author admits that gamers are \"... twice as likely as non-gamers to develop some programming ability\" (Lee3).","id":"Detail0.4496936935800053"},{"abbreviation":"Cite","comment":"*Needs Citation:*\nThis evidence reflects facts or information from an outside source. You need to cite your source for this section and include the citation in your Works Cited page.\n*Examples:*\nAs the author explains, \"Direct quote\" (Smith 22).\nAccording to Amy Smith, \"Direct quote\" (22).\nThe author argues that...indirect quote (\"Article Title\" 4).\nIn _Canterbury Tales..._ indirect quotation (16).","id":"Cite0.42836032879943486"},{"type":"text","abbreviation":"Comment","comment":"*Needs Commentary:*\nProvide your own comments about the concrete detail. In an argumentative essay, offer your opinion or insight, analyze (examine in parts), or evaluate. In an informative/explanatory essay, interpret, explain, analyze (examine in parts), or provide a definition. Commentary does not add additional details or information. Use an appropriate transition word or phrase to introduce commentary sentences.\n*Example:* As a result, gamers learn how to optimize their games with modifications.","id":"Comment0.3296386351959779"},{"type":"text","abbreviation":"CRPara","comment":"*Needs Counterargument and Refutation Paragraph:*\nInclude a counterargument and refutation in the last paragraph before the conclusion in an argumentative essay. Begin with a transition word or phrase which signals the opposing point of view, and complete a topic sentence, which state an opposing argument against your claim. Use concrete details to provide the best evidence for the opposing argument. Respond with concrete details and/or commentary sentences to refute (disprove) these arguments. Make sure to include clear transition words or phrases to indicate the shifts in point of view.\n*Counterargument Example:* In contrast, opponents argue that technological skills remain less important than traditional reading and math skills.\n*Refutation Example:* However, studies have demonstrated that technological skills learned by video gaming significantly improve higher level reading and math abilities (Jones 22). Clearly, both technological and academic skills are important to learn.","id":"CRPara0.48332658523828176"},{"type":"text","abbreviation":"CREmbd","comment":"*Needs Embedded Counterargument and Refutation:*\nEmbed (place within) a counterargument and refutation within the last concrete detail and commentary of each body paragraph. Begin the concrete detail with a transition word or phrase which signals the opposing point of view, and provide evidence which counters the argument presented in your topic sentence (the counterargument). Respond with a concrete detail and commentary sentence or two to refute disprove the argument (refutation).\n*Counterargument Example:* In contrast, opponents argue that video gaming decreases the attention spans of gamers, because other activities, such as schoolwork, cannot constantly stimulate learners in the same manner as video games.\n*Refutation Example:* However, in a recent survey, 75% of avid gamers report a longer attention span than those who do not play video games frequently (Jones 23). Clearly, both technological and academic skills are important to learn.","id":"CREmbd0.5146259872252068"},{"abbreviation":"ThRest","comment":"*Needs Thesis Restatement:*\nBegin the concluding paragraph of your essay with a thesis restatement. This sentence paraphrases the thesis to remind the reader about the focus of the essay.","id":"ThRest0.4884695434191637"},{"type":"text","abbreviation":"Conclsn","comment":"*Revise Conclusion:*\nThe conclusion comments on the evidence presented in the body paragraphs to satisfy the reader that the thesis statement has been proved *(in an argumentative essay)* or its purpose achieved *(in an informative/explanatory essay)*. Choose the conclusion strategies which best comment on the concrete details and commentary of your body paragraphs with a variety of the *GQ SALES Conclusion Strategies:* G̲eneralization, Q̲uestion for Further Study, Statement of S̲ignificance, A̲pplication, L̲imitations, E̲mphasis of Key Point, ̲S̲ummary Statement, or for the argumentative essay, a C̲all to Action. Use an appropriate transition word or phrase to introduce the conclusion comments.\n*Application Example:* Moreover, video gaming has further benefits beyond the development of technological skills. Gamers develop teamwork skills, which are becoming increasingly helpful in the school and in the workplace. Indeed, video gaming can be purposeful play.","id":"Conclsn0.7287205775496772"},{"abbreviation":"Bias","comment":"*Biased Reasoning:*\nYour reasoning here is faulty or misleading. Whether used intentionally or unintentionally to support your argument or manipulate information to achieve your purpose, it violates accepted rules of evidence and needs to be deleted or revised.\n*Example:* The horrible coach of our school basketball team did not see fit to choose me as a starter.\n*Revision:* The coach of our school basketball team did not choose me as a starter.","id":"Bias0.12958596957799973"},{"type":"text","abbreviation":"Synonym","comment":"*Eliminate Synonym Error:*\nA term has been substituted for another, yet the terms are not same.\n*Example:* The undemocratic government had only one political party-a true dictatorship.\n*Explanation:* The writer substitutes _dictatorship_ for _undemocratic_; yet not all undemocratic governments are dictatorships.","id":"Synonym0.7500962445772512"},{"abbreviation":"NonSeq","comment":"*Eliminate Non Sequitur Error:*\nThe conclusion cannot be reached from the facts presented.\n*Example:* If the sky is blue, and blue is the color of the ocean; then the sky must be made of ocean water.\n*Explanation:* The conclusion that \"the sky must be made of ocean water\" does not follow logically from the facts presented.","id":"NonSeq0.7890203189300105"},{"abbreviation":"RedHerr","comment":"*Eliminate Red Herring Error:*\nAn unconnected reference distracts the reader from the argument.\n*Example:* Poverty is the most important problem; however, the world has always had poor people.\n*Explanation:* The second clause attempts to distract the reader from the issue of poverty as the most important problem.","id":"RedHerr0.18324591548709446"},{"type":"text","abbreviation":"General","comment":"*Eliminate Unsupported Generalization Error:*\nA generalization has been made from a fact without justification.\n*Example:* Bob and Ara are blondes. They both excel at sports. All blondes excel at sports. \n*Explanation:* The fact that two blondes are good at sports does not justify the generalization for _all_ blondes.","id":"General0.34965047174554"},{"abbreviation":"Poison","comment":"*Eliminate Poisoning the Well Error:*\nThe argument is weakened by a criticism in the argument itself.\n*Example:* The president proposes lowering taxes to encourage spending, even though economists label the plan as \"unworkable.\"\n*Explanation:* The president's proposal is weakened by the economists' comment.","id":"Poison0.48505044508779704"},{"abbreviation":"CauseEff","comment":"*Eliminate Cause and Effect Error:*\nNo necessary cause-effect relationship has been established.\n*Example:* That cough syrup commercial aired again. I coughed again. Cough syrup commercials make me cough.\n*Explanation:* Coughing after a commercial is a matter of coincidence. Commercials do not cause coughing.","id":"CauseEff0.9880862056121491"},{"abbreviation":"BegQuest","comment":"*Eliminate Begging the Question Error:*\nSomething unproven has been assumed to be true in order to support the argument.\n*Example:* No one likes the poor musicianship of country music.\n*Explanation:* The statement assumes that country music has poor musicians in order to support the argument.","id":"BegQuest0.8446695026422137"},{"abbreviation":"EitherOr","comment":"*Eliminate Either-Or Error:*\nA false choice has been made between two ideas or issues that ignores other options.\n*Example:* Either you support the president, or you are not a true American.\n*Explanation:* The statement ignores other options that true Americans might choose.","id":"EitherOr0.3304421232764816"},{"abbreviation":"Compare","comment":"*Eliminate Comparison Error:*\nSimilarities or differences have been made between two unrelated ideas or issues.\n*Example:* The price of Chinese tea has increased and so has the price of American gasoline.\n*Explanation:* The price of tea and gas are unrelated issues and cannot be compared.","id":"Compare0.3994320532855493"},{"abbreviation":"QuesAuthr","comment":"*Eliminate Questionable Authority Error:*\nAsource has been cited that does not have established expertise.\n*Examples:* Experts say the world will run out of oil in 9 years, and a Harvard scientist claims that love at first sight is possible.\n*Explanation:* \"Experts\" are unnamed, and a scientist is not an expert in love.","id":"QuesAuthr0.028210903485573313"},{"abbreviation":"Contra","comment":"*Eliminate Contradiction Error:*\nThis statement contradictswhat has already been stated in the argument.\n*Example:* Skateboarding is the safest sport. Skateboarding injuries result in more hospital visits than any other sport.\n*Explanation:* Skateboard injuries contradict the claim that the sport is safe.","id":"Contra0.21159140361683382"},{"type":"text","abbreviation":"Incons","comment":"*Eliminate Inconsistency Error:*\nOne part of the argument does not agree with or is inconsistent with another part.\n*Example:* Children should wear helmets while riding bicycles, but not while in-line skating. \n*Explanation:* The assertion that one activity should require helmets, but not the other, is inconsistent.","id":"Incons0.2678292344833342"},{"type":"text","abbreviation":"Omission","comment":"*Eliminate Omission Error:* Necessaryinformation is missing in the argument.\n*Example:* The clock keeps the best time.\n*Explanation:* The fact that the clock is the only one was not stated.","id":"Omission0.01169078809606039"},{"abbreviation":"Simple","comment":"*Eliminate Oversimplification Error:*\nA complicated idea or issue has been oversimplified.\n*Example:* Baseball is a simple game of pitching, running, hitting, and fielding.\n*Explanation:* This statement ignores the complicated components such as baseball strategy, substitutions, and statistical probability.","id":"Simple0.3365540580236164"},{"type":"text","abbreviation":"Sampling","comment":"*Eliminate Sampling Error:*\nThis conclusion cannot be made due to insufficient sample size or an unreliable sample group.\n*Example:* Everyone should floss daily. Three out of four dentists agree.\n*Explanation:* Only four dentists were surveyed, and some may be paid by dental floss companies to promote their product.","id":"Sampling0.14068429955939865"},{"abbreviation":"PosEStr","comment":"*Positive Essay Structure Comment:*\nYou have demonstrated an excellent understanding about how an essay should be structured with a hook, link, context, and thesis statement in the introduction; body paragraphs with topic sentences, concrete details, commentary, and concluding statements; and a conclusion paragraph with thesis restatement and conclusion strategies.","id":"PosEStr0.6748566473412749"},{"abbreviation":"PosECon","comment":"*Positive Essay Content Comment:*\nYour skillful use of research and information to prepare this essay is impressive. Not only have you marshalled the expertise of others on the subject of your writing, but you have also added creative and original thinking in this essay.","id":"PosECon0.5089525033444531"}],"id":"Essay Structure and Content0.500624448169102"},{"type":"default","name":"Narrative Structure and Content","comments":[{"abbreviation":"Lead","comment":"*Revise Narrative Lead:*\nThe first sentence or two of your story should _hook_ your reader's interest. In a story or article, the _hook_ is also called a _lead._ The lead introduces the _exposition_ (or _basic situation_), which also introduces the main characters, setting, and any essential background information. For short stories, try using one of these leads to begin your story:\n*▪* A *dialogue lead* begins the story with a short, but interesting, exciting, or suspenseful conversation between two of the story characters.\n*Example:* \"Did you see that?\" screamed my brother. \"It just about took off my head. Quick, let's get under cover before it comes back!\"\n*▪* An *action lead* begins the story with the main character or characters involved in some kind of exciting, suspenseful, adventurous, or surprising activity.\n*Example:* Whoosh! the parachute opens and the straps tug violently at my shoulders.\n*▪* A *sensory lead* begins the story with vivid sensory images.\n*Example:* The snow crunched under my boots, and the wind whistled mercilessly through the bending and snapping pine trees. A faint smell of smoke kept me walking down the mountain.\n*▪* A *flashback lead* begins the story in the character's past.\n*Example:* I was only six-years-old when the tornado hit. Without any warning siren, the wind came screaming through our neighborhood. Our house creaked and groaned and shuddered. Suddenly the roof flew off in one single piece. The sky was black as night.\n*▪* An *inner thoughts lead* begins the story with what the main character is thinking.\n*Example:* I had no idea that it would come to this. Although I usually pride myself on being ready for anything, this one caught me flat-footed.","id":"Lead0.5694111723380377"},{"abbreviation":"CharInt","comment":"*Needs Character Introduction:*\nNeeds a more detailed character description to introduce your main character or characters. _Tell_ or _show_ the character traits that will best define your character's personality, relationships to other characters, and role in the story. Following are types of character roles found in many narratives:\n*▪* The _protagonist_ is the main character who is involved in the primary conflict. Usually, the protagonist is the hero of the story, but the protagonist can sometimes play the role of the _anti-hero._ Often, a protagonist has a character flaw which influences the plot.\n*▪* The _antagonist_ is the character who opposes the protagonist in the conflict. The antagonist may act as the villain or _bad guy_ in the story.\n*▪* The _foil_ character used to demonstrate a sharp contrast to another character, such as the protagonist, in order to more clearly define the other.\n*▪* Minor characters do not play the essential roles of the main characters. However, minor characters can dramatically influence the plot and other characters.","id":"CharInt0.9903874855174979"},{"abbreviation":"Setting","comment":"*Revise Setting:*\nNeeds more specific setting details. The setting is the time and place of the story. It may include the historical and cultural context for the characters and plot. The setting establishes the _tone_ and _mood_ of the story in the _exposition_ (or _basic situation_). The _tone_ is the author's attitude or feelings about the characters, the plot, and the reader. The _mood_ is how the reader feels in response to the tone.\n*Example:* The factory whistle blew for quitting time: five o'clock, and not a minute too soon on this dreary January day, far from the cheer of Christmas. The year was 1938. My hometown of Akron, Ohio, was no different than any other midwestern, blue collar town.","id":"Setting0.9766025051000027"},{"abbreviation":"Conflct","comment":"*Clarify Conflict:*\nThe conflict is unclear. The conflict is the key struggle which arises from the _exposition_ (or _basic situation_) and is developed throughout the plot. The conflict may be external or internal.\n*External Conflict Examples:* character vs. character, character vs. nature, character vs. technology, character vs. society, character vs. supernatural, character vs. fate, character vs. the unknown\n*Internal Conflict Examples:* character vs. emotions, character vs. needs or desires, character vs. temptations, character vs. the past. Stories may have both primary and secondary conflicts.","id":"Conflct0.9847854355219985"},{"abbreviation":"POV","comment":"*Inconsistent Point of View:*\nThe point of view is inconsistent. The point of view refers to how the story is told. Most authors use one of these points of view to tell the story:\n*▪* First Person: One of the characters tells the story using I. The reader only knows what the character knows and senses.\n*Example:* I walked into the hallway, not knowing where it would lead.\n*▪* Third Person Limited: The narrator, who is not involved in the story, tells the reader what one main character knows and senses.\n*Example:* Marsha and Brad left the house together. Marta wondered if they would return.\n*▪* Third Person Omniscient: The narrator or character telling the story knows and senses everything about the characters' past, present, and future. _Omniscient_ means _all-knowing._\n*Example:* The children did not know that the zombies were waiting for them at the end of the tunnel.","id":"POV0.6661511271096905"},{"abbreviation":"RisAct","comment":"*Needs More Rising Action:*\nNeeds more plot development before the story climax. Rising action is the series of events that develop the characters and the conflict to prepare the reader for the story climax.","id":"RisAct0.7261415642974929"},{"abbreviation":"Climax","comment":"*Revise Climax:*\nNeeds a more detailed climax. The climax is the most exciting part of the story. It is also the turning point of the story in which the interaction of the characters dealing with the primary conflict is at the highest point of interest, intensity, or suspense. The climax is usually included toward the end of the story.","id":"Climax0.6816495349268363"},{"abbreviation":"FallAct","comment":"*Needs More Falling Action:*\nThe falling action serves as a transition between the climax and the resolution. Your resolution follows too soon after the climax. More falling action details are needed to tie up loose ends with the plot and characters and to settle the reader following the intensity of the climax.","id":"FallAct0.4724956078308642"},{"abbreviation":"Resltn","comment":"*Clarify Resolution:*\nNeeds a more detailed and clear resolution. The resolution follows the falling action and resolves the key conflict or conflicts of the story. It provides a satisfying ending in which the reader discovers what happens to the main characters and how the plot draws to a close.","id":"Resltn0.846924907829053"},{"type":"text","abbreviation":"CharDev","comment":"*Needs More Character Development:*\nNeeds more detailed and specific character development. Use the *STEAL Characterization Strategy* to create interesting characters: *Speech* (how and what the characters say in dialogue); *Thought* (what the characters think); *Effect* on others (how the characters relate to one another); *Action* (what the characters do and the how they respond to the consequences of their actions); and *Looks* (the appearance of the characters).\nReveal the _character traits_ (what makes each person unique) through both _direct_ and _indirect_ characterization:\n_Direct_ characterization _tells_ the reader about the character traits through description.\n*Example:* Mr. Tang was patient and focused on the present.\n_Indirect_ characterization _shows_ the character traits through the plot, dialogue, action, and other characters.\n*Example:* His tie was perfectly placed, not too short and not too long.","id":"CharDev0.5858170044905402"},{"abbreviation":"NotChar","comment":"*Inconsistent Characterization:*\nThis doesn't seem to fit your character. Don't surprise or confuse your reader with speech or action that seems _out of character._ Keep consistent with the characterizations which you have already established:\n*▪* A _dynamic_ character changes significantly throughout the narrative. Also referred to as a round character, the character is complex with multiple traits and learns and grows throughout the story.\n*▪* A _static_ character remains the same throughout the narrative.\n*▪* A _flat_ character is a simple, minor character with one personality trait.\nWriters develop characters throughout the story in these ways:","id":"NotChar0.6002452957960984"},{"abbreviation":"Dialog","comment":"*Revise Dialogue:*\nUse these techniques to write engaging dialogue:\n*▪* Keep speeches short. Don't waste words or state the obvious.\n*▪* Good dialogue adds to the plot and can suggest action.\n*▪* Use authentic vocabulary and write the way your characters speak. Each character should have a consistent and unique voice, that is, their own way of saying things. Use more idiomatic expressions and slang in dialogue than you use to tell the story.\n*▪* Use a variety of speaker tags (other than _said_),and use them only when needed to show the reader whom is speaking.\n*▪* Don't overuse character names in dialogue.\n*▪* Don't use too much \"thinking\" dialogue.\n*▪* _Show_ the characters' character traits in their speech.\n*▪* Use some intentional fragments and contractions. We don't always speak in complete sentences.","id":"Dialog0.8697585330121083"},{"abbreviation":"Dscrptn","comment":"*Revise Description:*\nGood description uses _show me_, not _tell me_ writing. Use these techniques to write effective description:\n*▪* Description should be specific.\n*Example:* She walked down the stairs into the street.\n*Revision:* She walked down the wooden stairs into Laredo Street.\n*▪* Description should be detailed, but not too detailed.\n*Example:* The cool, yet refreshing breeze, blew over the excruciatingly hot patio.\n*Revision:* The cool breeze blew over the hot patio.\n*▪* Description should include a variety of the senses.\n*Example:* The smell of oven-baked cookies and the sounds of an old jazz song welcomed him into the sun-filled room.\n*▪* Description should clearly indicate changes in location.\n*Example:* Tasha changed direction, turning onto the one-way street.\n*▪* Description should balance location and action.\n*Example:* She reached for the flashlight on her nightstand, but it had been moved. Turning on the lamp, she examined the room. Something was not right. Something did not feel right. Something was missing on her chest of drawers. She jumped out of her bed.","id":"Dscrptn0.734086392878257"},{"abbreviation":"FigLng","comment":"*Clarify Figurative Language:*\nRevise the figurative language or substitute with literal language. Figurative language appeals to the senses of the reader by using non-literal figures of speech.\n*Examples:* simile, metaphor, personification, allusion, irony, imagery","id":"FigLng0.8615518481455009"},{"abbreviation":"ToneMood","comment":"*Inconsistent Tone and Mood:*\nThe tone of this section and the mood it creates don't fit with the rest of the story. The tone is the author's attitude or feelings about the characters, the plot, and the reader. The mood is how the reader feels in response to the tone. The tone and mood are shaped by word choice, figurative language, and how sentences are constructed to tell the story.\n*Examples of Tone:* positive, negative, sarcastic, humorous, optimistic, pessimistic, serious, reverent.\n*Examples of Mood:* enlightening, sympathetic, trusting, stressful, angry, relieved, convinced, nostalgic","id":"ToneMood0.7285889228355891"},{"abbreviation":"PlotTch","comment":"*Add Plot Technique:*\nConsider revising this section by adding a specific plot technique to engage your reader. The plot is the sequence of events that happen throughout a story. Certain writing techniques are used to enhance the interest of the plot:\n*▪* A _twist_ provides an unexpected or surprise ending. The conflict is resolved differently than the reader expects.\n*Example:* Tom Sawyer appears at his own funeral.\n*▪* A flashback interrupts the events of the plot to refer back to a past event, which is experienced by the characters as if in the present.\n*Example:* \"I remember the day of our wedding. I am dressed in a pastel blue tuxedo, waiting for my young bride to walk down the aisle.\"\n*▪* _Foreshadowing_ provides the reader hints or clues about something that will happen later in the story.\n*Example:* I opened the drawer and a hunting knife was hidden within the socks.\n*▪* _Symbolism_ is the use of concrete and specific people, places, or things as symbols to represent abstract ideas. The symbols are usually related to the theme of the story.\n*Examples:* A golden apple, a blood-red sun, the north star\n*▪* A motif is a repeated image, pattern, event, or idea that provides clues to understanding the theme.\n*Examples:* a bell ringing at key points in the story, a repeated number 7 when something good happens","id":"PlotTch0.05394010793920634"},{"abbreviation":"Theme","comment":"*Clarify Theme:*\nThe thematic subject and/or the theme needs further development. Short stories, like novels, include a theme. The thematic subject is the main idea which the author focuses upon in the text.\n*Examples:* lost love, growing up, facing adversity\nThe theme is the message or lesson about life that the author communicates to the reader about the thematic subject. The theme is usually implied (not stated) and is universal (applying to everyone). An author may share more than one theme.\n*Examples:* Absolute power corrupts absolutely. Seemingly good people have the capacity for evil.","id":"Theme0.003941620834237547"},{"abbreviation":"PosNStr","comment":"*Positive Narrative Structure Comment:*\nYou have demonstrated an exemplary understanding of how to write the exposition (basic situation) with a narrative lead, main character introductions, setting, and the primary conflict. You know how to structure a narrative plot with the rising action, the climax, the falling action, and a satisfying resolution that solves the conflict.","id":"PosNStr0.015338785539695365"},{"abbreviation":"PosNCon","comment":"*Positive Narrative Content Comment:*\nYour characters are realistic, their roles in the story are clear, and their character traits are well-described. The plot is interesting and entertaining. I so enjoyed your original and creative story.","id":"PosNCon0.3780540684952651"}],"id":"Narrative Structure and Content0.05510713186645355"},{"type":"default","name":"Sentence Formation and Writing Style","comments":[{"type":"text","abbreviation":"Combine","comment":"*Combine Simple Sentences:*\nCombine these short sentences into a compound, complex, or compound-complex sentence. Avoid writing more than two of the same patterns back-to-back unless you have a specific purpose for doing so. As a guideline, for sentence variety only 60% of your sentences should be simple sentences.\n*▪* A compound sentence has two or more independent clauses (nouns and connected verbs which express complete thoughts), joined by a comma-conjunction or a semicolon.\n*Example:* I like the way she talks, and she likes my voice.\n*▪* A complex sentence has both an independent clause and a dependent clause. A dependent clause begins with a subordinating conjunction and has a noun and a connected verb which does not express a complete thought. For sentence variety, place the dependent clause at the beginning, in the middle, and at the end of sentences.\n*Example:* When I finally left home, I cried for days.\n*▪* A compound-complex sentence has at least two independent clauses and at least one dependent clause.\n*Example:* After he ate lunch (dependent clause), Tam finished his chores (independent clause), and he took a nap (independent clause).\n*AAAWWUBBIS Memory Trick (to remember the subordinating conjunctions):* Most dependent clauses begin with these words: _After,_ _Although,_ _As,_ _When,_ _While,_ _Until,_ _Because,_ _Before,_ _If,_ or _Since_","id":"Combine0.8527568027458767"},{"abbreviation":"SentVar","comment":"*Needs Sentence Variety:*\nVary the types of sentence structures you use to keep your reader interested. Revising sentences with different grammatical sentence openers improves sentence variety. As a general guideline, no more than 60% of sentences should be constructed in the subject-verb-object sentence pattern.\n*Example:* They (subject) eat (verb) too many hamburgers (object).\nTo revise, consider starting with a prepositional phrase (_At the table_), a participle or participial phrase (_Starved, Starving_), a direct object (_Too many hamburgers_), an adjective (_Too many_), an adverb (Often), a gerund or gerund phrase (_Eating too many hamburgers..._ verb) or a nominative absolute (_Their stomachs completely emptied_)\nAvoid writing more than two of the same sentence patterns back-to-back unless you have a specific purpose for doing so.","id":"SentVar0.26157458668035694"},{"type":"text","abbreviation":"ParlStr","comment":"*Needs Parallel Structure:*\nRepeat grammatical structures in sentences and paragraphs to create a writing rhythm. Pay special attention to these sentence components to create parallelism.\n*▪* Verb forms\n*Example:* We cannot hope to dedicate... We can't consecrate... and hallowing the ground we cannot do.\n*Revision:* We cannot dedicate... We cannot consecrate... We cannot hallow this ground (Lincoln's \"Gettysburg Address\").\n*▪* Noun phrase constructions\n*Example:* We studied the French, Spanish, people from England, and those Portuguese\n*Revision:* We studied the French, the Spanish, the English, and the Portuguese.\n*▪* Gerunds (verb forms which act as nouns)\n*Example:* To run a marathon, climb Mt. Shasta, and a mile swim are on my bucket list.\n*Revision:* Running a marathon, climbing Mt. Shasta, and swimming a mile are on my bucket list.\n*▪* Coordinating conjunctions\n*Example:* Smoking can result in lung disease or even be deadly.\n*Revision:* Smoking can result _in lung disease_ or even _in death_.","id":"ParlStr0.1753865128241996"},{"type":"text","abbreviation":"Chron","comment":"*Rearrange in Chronological Order:*\n_Chronological_ refers to the order of time, from older events to newer ones. Use transition words such as _first_, _second_, _later_, _next_, _before_, _for one_, _for another_, _previously_, _then_, _finally_, _following_, _since_, and _now_ to establish a time sequence from old to new.\n*Example:* Mary asked if she could go with us, later she got permission from her parents, but before both she had cancelled her plans.\n*Revision:* First, Mary cancelled her plans. Then she asked if she could go with us. Later, she got permission from her parents.","id":"Chron0.9805005290883035"},{"type":"text","abbreviation":"Interpt","comment":"*Eliminate Sentence Interruption:*\nSentence interruptions can ruin the flow of a sentence. Good sentences have rhythm. Awkward or distracting interruptions reduce the reader's understanding of what the writer intends to say. Rearrange the sentence or simply delete the interruptions.\n*Examples:* This was not a good idea, although I must admit I didn't have any better ones, and it was bound to fail.\n*Revision:* This was not a good idea and it was bound to fail, although I must admit I didn't have any better ones.","id":"Interpt0.218114242048687"},{"abbreviation":"OffTop","comment":"*Off Topic:*\nThe focus of this section does not support the thesis statement. Consider eliminating this section, revising to better demonstrate how it provides support, or substituting with something more relevant (that which directly applies).\n*Example:* Baseball has been called a \"simple game\"; however, it does require skilled decision-making. Hot dogs always taste best at the ballpark (Off Topic).","id":"OffTop0.30721348637903767"},{"abbreviation":"Connect","comment":"*Clarify Connection:*\nHow does this fit with other sections? Consider adding transitions or repeat wording to show relationships. Common relationships include cause and effect, comparison and contrast, and problem to solution.","id":"Connect0.7738485035534741"},{"abbreviation":"Place","comment":"*Out of Place:*\nThis section seems out of place. Consider rearranging sentences or paragraphs to maintain the focus of your reader and unify your writing.","id":"Place0.7386946927949258"},{"abbreviation":"NotClr","comment":"*Not Clear:*\nThis section is confusing and does not seem to fit with the rest. Provide an example, a definition, a comparison or contrast, or more explanation to make it more understandable.\n*Example:* Many still farmed vegetable crops which were in over-supply.\n*Revision:* Many farmers continued to grow vegetables, such as corn, when too much corn was already on the shelves of supermarkets.","id":"NotClr0.31309427840319093"},{"abbreviation":"Awk","comment":"*Awkward:*\nThe construction of this sentence makes it hard to follow. Consider revising the word order, changing from passive to active voice, and/or eliminating phrases and clauses which create distance between the subject and predicate.\n*Example:* The call, made by the police, to carry out the proposed solution to the problem, was not carried out majority members of the community.\n*Revision:* Most people in the community did not do what the police suggested to solve the problem.","id":"Awk0.13295648210068944"},{"abbreviation":"Trans","comment":"*Needs Transition:*\nUse a transition word or phrase help the reader understand the connection between or shift from one thought to another. Transitions may be placed at the beginning, middle, or end of sentences.\n*Examples:* _First_, she had practiced; however, she practiced incorrectly and _so_ was unsuccessful _for these reasons_.","id":"Trans0.9234919092965861"},{"abbreviation":"Redncy","comment":"*Redundancy:*\nThis section repeats an argument, information, ideas, or explanation already used in the essay or provides _too much of the same_. Often, a writer unnecessarily repeats too many examples, comparisons, facts, or explanations when one or two provides adequate support.\n*Example:* The grocer arranged the green vegetables, such as peas, beans, kale, and peppers, where the shoppers could see them in a display case.\n*Revision:* The grocer arranged the green vegetables, such as peas and beans, in a display case.","id":"Redncy0.22016596339418193"},{"type":"text","abbreviation":"GetSpf","comment":"*Get Specific:*\nThe concrete detail is too general. Substitute with more specific evidence or details to convince, inform, or explain. Choose among these types of evidence: F̲act, E̲xample, S̲tatistic, C̲omparison, Quote from an A̲uthority, L̲ogic, or E̲xperience *(FE SCALE)*.\n*Example:* Many people visit recreational areas.\n*Revision:* Close to 85% of Americans visited recreational areas, such as parks, beaches, and national forests this year (Matthews 34).","id":"GetSpf0.3389373435380758"},{"abbreviation":"NotCons","comment":"*Not Consistent:*\nThe content or tone of the argument or information has changed, is contradictory, or has been taken in a different direction than what has been said before. Revise to maintain consistent support of your thesis statement.\n*Example:* The math teacher was highly educated, yet she did not know much math.","id":"NotCons0.9058018370901992"},{"abbreviation":"Omission","comment":"*Omission:*\nIt seems that a word, key idea, information, or explanation is missing here. Re-read what you have written from the reader's point of view to to see what needs to be added.\n*Example:* The Folsom High School Band has the best band in the city.\n*Revision:* The Folsom High School Band has the only band in the city, but it is excellent.","id":"Omission0.9554605808797318"},{"abbreviation":"NotCorr","comment":"*Not Correct:*\nThis fact does not seem to be correct, or you have misapplied the evidence. Check your sources and revise as needed.\n*Example:* The earth is a sphere and completely flat.","id":"NotCorr0.45102171602332564"},{"abbreviation":"Seq","comment":"*Sequence Issue:*\nThis sentence is improperly placed and is confusing to the reader. Re-read the paragraph to determine proper placement and revise or delete if it does not fit in to the order or flow of the paragraph.\n*Examples of Proper Sequence:* General to specific, first to last, cause to effect, problem to solution, old to new.","id":"Seq0.674720188291857"},{"abbreviation":"Overst","comment":"*Overstatement:*\nYour analysis or conclusion goes beyond the evidence that you present. It seems exaggerated in order to prove your point. Commentary which limits the scope of interpretation, explanation, analysis, or evaluation is generally more convincing to your reader.\n*Example:* Everyone was completely shocked to hear the worst news ever.\n*Revision:* Many were shocked to hear the bad news.","id":"Overst0.9390671475166883"},{"abbreviation":"Commit","comment":"*Revise Non-Committal Language:*\nState your assertions (statements of fact of belief) forcefully without hesitation or qualification.\n*Essay Example:* There were many possible reasons as to why the war took place.\n*Essay Revision:* The war began because of three key reasons.\n*Story Example:* His words may have upset her, and her reaction and crying was less controlled than it could have been.\n*Story Revision:* His words cut her like a knife, and she burst into uncontrollable sobbing.","id":"Commit0.24922399365783998"},{"abbreviation":"Rambling","comment":"*Revise Rambling Sentence:*\nA rambling sentence provides the main thought at the beginning of the sentence and then adds unnecessary or unrelated details. Delete that which is unnecessary.","id":"Rambling0.5040291913973778"},{"abbreviation":"BalSent","comment":"*Correct Unbalanced Sentence:*\nA balanced sentence includes similar importance and grammatical constructions at the beginning and end of the sentence.\n*Example:* She told the joke in school, and once again at home she repeated it.\n*Revision:* She told the joke in school, and she repeated it at home.","id":"BalSent0.28722405026740416"},{"abbreviation":"Cliché","comment":"*Eliminate the Cliché:*\nA cliché is an overused expression.\n*Example:* The research left _no stone unturned._","id":"Cliché0.23122977639689246"},{"abbreviation":"Padding","comment":"*Eliminate Padding:*\nPadding is needless or pointless writing that adds to length, but not to meaning.","id":"Padding0.723389243485917"},{"type":"text","abbreviation":"PairRed","comment":"*Delete Paired Redundancy:*\nA paired redundancy consists of two words, each of which implies (suggests) the meaning of the other. Often used redundant pairs include the following: _each individual_, _end result_, _final ending_, _final result_, _future plans_, _past history_, _terrible tragedy_, _true facts_,and _unexpected surprise_.\n*Example:* The _future plans_ of each individual remain uncertain.\n*Revision:* Individual plans remain uncertain.","id":"PairRed0.4374024784047812"},{"abbreviation":"InterPro","comment":"*Rearrange Interrogative Pronoun:*\nAn interrogative pronoun is used to ask a question. Only five pronouns are interrogative pronouns: _who_, _whom_, _whose_, _what_, and _which_. Each of these interrogative pronouns can add the \"_ever\" and \"_soever\" suffixes. Placing the interrogative pronoun at the beginning of a sentence is often less confusing for the reader than placing the interrogative pronoun in the middle of a sentence as in an indirect question.\n*Example:* I don't know whose dog that is out on the porch.\n*Revision:*Whose dog is that out on the porch?","id":"InterPro0.6651672704640517"},{"type":"text","abbreviation":"Circum","comment":"*Delete Circumlocution:*\nA _circumlocution_ is a roundabout expression that does not add additional meaning to the sentence. Circumlocutions often include unnecessary adjectives or adverbs. Substitute circumlocutions with these words: _because_, _about_, _must_ or _should_, _can_, and _might_ or _may_.\n*Circumlocution Examples and Revisions:*\n*-Replace* _because of (or as a result of) the fact that_ with _because_.\n*-Replace* _regarding the situation in which_ with _about_.\n*-Replace* _it is important that_ with _must_ or _should_.\n*-Replace* _is able to_ with _can_.\n*-Replace* _it is possible that_ with _might_ or _may_.","id":"Circum0.9387390864443128"},{"type":"text","abbreviation":"Nomin","comment":"*Revise Nominalization:*\nA nominalization is a noun phrase created from verbs or adjectives.\nChange a nominalization to a verb, by locating an action verb hidden in the nominalization and using it as the main verb.\n*Example:* A teacher shortage is the biggest fear of the School Board.\n*Revision:*_The School Board fears a teacher shortage._","id":"Nomin0.7203105550710971"},{"type":"text","abbreviation":"LangReg","comment":"*Inconsistent Language Register:*\nA _language register_ is a special variety of language used in a specific social situation or for a particular purpose. When writing essays, keeping the same register means using a consistent voice, such as the writing style, vocabulary, and tone. When writing narratives, keeping the same register within a particular setting or set of characters provides authenticity (truthful, real, or lifelike).\n*Examples of Different Registers:*\n\"Father, please stop using your humor. It bothers me.\"\n\"Dad, quit kiddin' around. You messin' with me.\"","id":"LangReg0.3996187664929476"},{"abbreviation":"PosSFrm","comment":"*Positive Sentence Formation Comment:*\nYou have carefully constructed your sentences to ensure that _how_ you communicate is considered just as important as _what_ you have to say. Your sentences are well-designed, concise, and have a variety of sentence constructions.","id":"PosSFrm0.4010628129022811"},{"abbreviation":"PosWrSt","comment":"*Positive Writing Style Comment:*\nYou demonstrate that you know the purpose of the writing prompt (assignment) and the needs of your reader. Your writing style make your paper easy to read and understand. Sentences are in proper order and nicely transition from one to another.","id":"PosWrSt0.9704555238397652"}],"id":"Sentence Formation and Writing Style0.19959048192951867"},{"type":"default","name":"Word Choice","comments":[{"abbreviation":"UnExpr","comment":"*Delete Unnecessary Expressions:*\nDelete words, phrases, and clauses that do not add meaning.\n*Examples:* I think, I believe, In my opinion, from this writer's point of view, at the end of the day, when all is said and done, in light of these facts","id":"UnExpr0.5582273051324875"},{"abbreviation":"DbNeg","comment":"*Revise Double Negative:*\nDon't use double negatives to indicate a positive in formal essays or research papers.\n*Examples:* You should _not fail_ to use soap to wash dishes. Don't not do that ever.\n*Revision:* Always use soap to wash dishes.","id":"DbNeg0.8504011819596204"},{"abbreviation":"Wordy","comment":"*Eliminate Wordiness:*\nThis section is longer than it needs to be. Consider deleting words, phrases, or clauses which interrupt the flow of your ideas, or consider re-wording−especially with stronger verbs and more specific nouns. Often, using clauses beginning with _who, whom, which,_ and _that_ and too many prepositional phrases create wordiness.\n*Example:* The girl, whom I used to consider as a friend, but left me to eat lunch alone, which was extremely mean in the cafeteria during lunch on Tuesday ignored me.\n*Revision:* The mean girl ignored me in the cafeteria last Tuesday.","id":"Wordy0.4094411430506968"},{"abbreviation":"To-beVb","comment":"*Revise Too Many \"to be\" Verbs:*\nLimit using so many \"to be\" verbs: _is, am, are, was, were, be, being, been_. To replace \"to be\" verbs: 1. *Substitute* a more active verb. 2. *Convert* one of the words in the sentence to a verb form. 3. *Change* the beginning of the sentence. 4. *Combine* the sentence which has the \"to be\" verb with the sentence before or after to use another stronger and specific verb.\n*Substitute Example:* The child _was_ sad.\n*Revision:* The child _felt_ sad.\n*Convert Example:* Charles Schulz _was_ the _creator_ of the _Peanuts_ cartoon strip.\n*Revision:* Charles Schulz _created_ the _Peanuts_ cartoon strip.\n*Change Example:* The run-away car _will be_ stopped by the tire spikes.\n*Revision:* The tire spikes will stop the run-away car.\n*Combine Example:* The sensitive child _is_ terrified. She _is_ feeling that way because of the news story.\n*Revision:* The news story terrified the sensitive child.","id":"To-beVb0.2168281706409767"},{"abbreviation":"WC","comment":"*Change Word Choice:*\nThis word choice is incorrect or unclear. To revise, either delete the word or use a thesaurus to substitute another word which fits better. Check its definition in a dictionary.\n*Example:* The _gigantic_ little rodent squeezed into its mouse hole.\n*Revision:* The little mouse squeezed into its mouse hole.","id":"WC0.14604896036409887"},{"abbreviation":"WordOrd","comment":"*Revise Word Order:*\nAdjectives are placed before nouns, and subjects before verbs, in most sentences.\n*Examples:* Both birds red and blue chirped.\n*Revisions:* The red and blue birds both chirped.","id":"WordOrd0.8762146172501515"},{"abbreviation":"Rep","comment":"*Repetitive:*\nThis word or phrase has been used excessively. Use a pronoun, synonym, or restatement instead of repeating this word. Or simply revise the sentence to omit.\n*Example:* She carefully planned the party, being careful to listen to advice.\n*Revision:* She planned the party, being careful to listen to advice.","id":"Rep0.7896468709418629"},{"type":"text","abbreviation":"Delete","comment":"*Delete Expletive:*\nAn expletive is an unnecessary word which serves no grammatical function and provides no meaning. The expletives _here, there,_ and _it_ followed by \"to be\" verbs (_is, am, are, was, were, be, being,_ and _been_), frequently begin awkward sentences which end with a noun or pronoun and a relative clause beginning with _that_, _which_, or _who_.\n*Examples:* Here (There) are four friends who work for the company. It is the race Ben ran that he won.\nTo eliminate the unnecessary _here, there,_ and _it_ sentence-starters, place the subject of the sentence at the beginning.\n*Revisions:* Four friends work for the company. Ben won that race.","id":"Delete0.324697312649022"},{"type":"text","abbreviation":"RevWord","comment":"*Revise Complex Word:*\nA complex word is a difficult or technical word that does not fit the style of writing. Only use a difficult or technical word when a simpler word will not communicate the exact meaning intended. Be careful to use a word exactly as it is defined.\n*Example:* The children enjoy playing with their new canine.\n*Revision:* The children enjoy playing with their new dog.\n*Revise Wordy Noun Constructions:* Replace \"_tion\" and \"_sion\" noun constructions with strong verbs when possible.\n*Noun Construction Example:* He turned in the _application for the job_.\n*Strong Verb Revision:* He _applied_ for the job.","id":"RevWord0.12958451736846444"},{"abbreviation":"Def","comment":"*Needs Definition:*\nThis term or word is not commonly understood or is used in a special way must be italicized. Support its definition and how you mean to use it with surrounding context clues, such as synonyms, antonyms, and examples. Alternately, provide its definition in parentheses or as an explanatory phrase, clause, or sentence.\n*Examples:* He promised revisions, not the status quo. The _zeitgeist_ (spirit of the times) remained hopeful.","id":"Def0.8825616332989745"},{"type":"text","abbreviation":"3rdPer","comment":"*Use Third-Person Point of View:*\nDon't use the first-person pronouns: _I, me, we, us, my, mine, our, ours, ourselves_ or the second-person pronouns: _you, your, yours, yourselves_ in your essay. Most essays are written in the third-person point of view to demonstrate objectivity (unbiased fair treatment). These third-person pronouns take the place of nouns:\n*▪* *He, she, it, one, they* (subject case pronouns)\n*▪* *Him, her, it, one, them* (object case pronouns)\n*▪* *His, hers, its, theirs* (possessive pronouns)\n*▪* *Himself, herself, itself, oneself, themselves* (reflexive/intensive pronoun)","id":"3rdPer0.6307502248005561"},{"abbreviation":"ModPrep","comment":"*Substitute Modifiers for Wordy Prepositional Phrases:*\nReplace wordy prepositional phrases with concise modifiers when possible. The prepositional phrase shows a relationship between a word indicating location, position, or time and its object (_under the bed_). A modifier is an adjective or an adverb which compares one thing to another.\n*Example:* The principal _of the school_ supervised the painting _of the gym_.\n*Revision with Modifiers:* The _school principal_ supervised _painting the gym_.","id":"ModPrep0.3380708797424721"},{"abbreviation":"Slang","comment":"*Delete Slang:*\nDon't use slang in essays or other formal writing. Slang is informal language used with certain groups of people and in certain situations. It is more often used in conversation than in writing. Revise with formal language.\n*Example:* The _kids_ studied hard for their exams.\n*Revision:* The children studied hard for their exams.","id":"Slang0.6764742559136727"},{"type":"text","abbreviation":"FigSp","comment":"*Delete Figure of Speech:*\nDon't use figures of speech in essays or other formal writing. A figure of speech is a non-literal expression. In other words, it means something different than its exact words.\n*Examples:* When asked how he felt about getting an F on the test, he said, \"Just terrific,\" (verbal irony) but he always responds like whining baby (simile). \nRevise with direct, literal, and formal language.","id":"FigSp0.8570068035079084"},{"abbreviation":"IdmExp","comment":"*Delete Idiomatic Expression:*\nDon't use non-grammatical idiomatic expressions in essays or other formal writing. An idiomatic expression is a phrase or clause which cannot be translated word for word, and has a meaning of its own. Revise with formal language.\n*Example:* Jean let the _cat out of the bag_ about the plot of the upcoming episode.\n*Revision:* Jean revealed the plot of the upcoming episode.","id":"IdmExp0.811922994245283"},{"abbreviation":"Contrct","comment":"*Delete Contraction:*\nDon't use contractions in essays or formal writing. A contraction is a shortened form of one or two words (one of which is usually a verb). An apostrophe takes the place of a missing letter(s) at the beginning, middle, or end of the word.\n*Examples:* They _shouldn't_ talk when they don't understand the subject.\n*Revision:* They should not talk when they do not understand the subject.\nNarratives often include contractions, especially in dialogue.","id":"Contrct0.3208963007649275"},{"type":"text","abbreviation":"Abbr","comment":"*Delete Abbreviation:*\nDon't use abbreviations in essays or formal writing. An abbreviation uses a period to shorten a word or words.\n*Examples:* _So._ Dakota is in the _U.S._\n*Revision:* South Dakota is in the United States.\nHowever, common acronyms may be used in essays or formal writing. An acronym is any abbreviation formed from the first letters of each word in a phrase. Frequently used acronyms do not require periods.\n*Example:* They copied the HTML (Hyper Text Markup Language) code.","id":"Abbr0.05324501561213557"},{"abbreviation":"PosWC","comment":"*Positive Word Choice Comment:*\nAccurate and creative word choice are the keys to successful writing. You have taken the effort to select words, which mean what you want them to communicate and which provide interest and readability in your writing.","id":"PosWC0.2714090472946562"}],"id":"Word Choice0.4967636921944638"},{"type":"default","name":"Nouns, Pronouns, Adjectives","comments":[{"abbreviation":"SpfNoun","comment":"*Use Concrete Noun:*\nAvoid using abstract nouns which cannot be perceived by the senses.\n*Example:* I read the _news_ about the _hunger problem_ in Africa. Instead, use specific, concrete nouns which can be perceived by senses.\n*Example:* I read the article in the _Sacramento Bee_ about the famine and mass starvation in Liberia, Africa.","id":"SpfNoun0.3063408014799711"},{"type":"text","abbreviation":"Gerund","comment":"*Revise with Noun Phrase or Clause:*\nRevise this section, using a noun phrase or noun clause. A noun phrase consists of a noun with any related words.\n*Example:* _The calm and decisive prince_ served his subjects well.\nA noun clauseis a dependent clause that usually begins with _if_, _how_, _however_, _that_, the *\"wh\" words:* _what_, _when_, _where_, _which_, _who_, _whom_, _whose_, _why_, or the \"wh\"-ever words: _whatever_, _whenever_, _wherever_, _whichever_, _who(m)ever_.\n*Example:* _Whatever she told you to do, you should do._","id":"Gerund0.6223191320020947"},{"abbreviation":"RedPrn","comment":"*Revise with Gerund:*\nRevise this section, using a gerund or a gerund phrase. A gerund is an __ing_ verb that is used as a noun.\n*Example:* _Driving_ has become a necessary skill these days. A gerund phrase is an __ing_ verb, connected to related words, and is used as a noun.\n*Example:* _Driving a car_ has become a necessary skill these days.","id":"RedPrn0.9503849905160087"},{"type":"text","abbreviation":"SubPro","comment":"*Needs Subject Case Pronoun:*\nRevise with a subject case pronoun. Use the subject case pronouns: _I, you, he, she,_ and _it_ (singular) or _we, you,_ and _they_ (plural) for these functions:\n*▪* The subject of the sentence. A subject case pronoun that is part of a compound subject is placed last.\n*Examples: Abel and* _she_ attended the concert.\n*Substitution Trick:* Drop other nouns or pronouns in a compound subject to check if the remaining pronoun sounds right.\n*Example:* John and _I_ play video games. Drop and check ‒ _I_ play video games.\n*▪* A predicate nominative, which identifies a subject following a \"to be\" verb (_is, am, are, was, were, be, being, been_).\n*Example:* The man who got into trouble is _he_.\n*Substitution Trick:* Rephrase the sentence to check if the pronoun sounds right.\n*Example:* The last one to arrive was _he_ or _him_. Rephrase ‒ _He_, not _Him_, was the last one to arrive.","id":"SubPro0.3084169788789686"},{"abbreviation":"ObjPro","comment":"*Needs Object Case Pronoun:*\nRevise with an object case pronoun. Use the object case pronouns: _me, you, him, her, it_ (singular) or _us, you_,and _them_ (plural) for these functions:\n*▪* A direct object, answering What? or Whom? in response to the verb.\n*Example:* She hit _him_.\n*▪* *Place the *object case pronoun last in compound objects.\n*Example:* The friend gave Kathy and _us_ a bag of chips.\n*Substitution Trick:* Drop other nouns or pronouns in a compound object to check if the remaining pronoun sounds right.\n*Example:* She gave it to John and _me_ or _I_. Drop and check‒She gave it to _me_, not _I_.\n*▪* As the object of a prepositional phrase.\n*Example:* They smiled at _me_.\n*▪* An indirect object, answering For What? or For Whom? in response to the verb. The indirect object is usually placed before the direct object in a sentence.\n*Example:* He gave _her_ a pen.\n*▪* As an object connected to an _infinitive_ (_to_ + the base form of a verb).\n*Example:* She wants _to give them_ money.","id":"ObjPro0.32513492908639585"},{"abbreviation":"ProRe-st","comment":"*Pronoun Re-statement Error:*\nDon't restate the subject twice with a pronoun in the same sentence.\n*Examples:* That dog, which is friendly, _he_ was easy to train. Revision: That dog, who is friendly, was easy to train.","id":"ProRe-st0.12014540769657778"},{"type":"text","abbreviation":"ProAnt","comment":"*Revise Pronoun Antecedent Issue:*\nAn antecedent is the word, phrase, or clause to which a pronoun refers. Use these revision strategies to clarify the connection between the pronoun and its antecedent:\n*▪* Place the pronoun close to its antecedent.\n*Example:* _John_, just like Peter, enjoyed _his_ sports.\n*Revision:* _John_ enjoyed _his_ sports, just like Peter.\n*▪* Change either the pronoun or antecedent to be more specific.\n*Example:* He gave _the dog his bone_.\n*Revision:* He gave _Fido the dog bone_.\n*▪* Don't use a pronoun that refers to the object of a preposition.\n*Example:* In Twain's _Tom Sawyer_, _he_ uses political humor.\n*Revision:* Twain uses political humor in _Tom Sawyer_.\n*▪* Use a singular pronoun to refer to the antecedent when the antecedent is uncountable.\n*Example:* _All_ of the salt fell out of _their_ bag.\n*Revision:* _All_ of the salt fell out of _its_ bag.\n*▪* Don't have a pronoun refer to a possessive antecedent.\n*Examples:* In San Diego's zoo, _they_ treat _their_ animals well.\n*Revision:* San Diego Zoo trainers treat their animals well.","id":"ProAnt0.1000935232192417"},{"type":"text","abbreviation":"RelPro","comment":"*Correct Relative Pronoun:*\nYou used the wrong relative pronoun to start this adjective clause. Of the relative pronouns: _that_, _which_, _who_, _whom_, and _whose_, the pronoun _that_ can refer to people or things in general. Use _which_ for specific things and _who, whom,_ and _whose_ for specific people, animals, and characters.\n*Who and Whom Trick:* _Who_ is in the subject case and acts upon a verb. Substitute _he_ or _they_, rearrange the sentence to make sense,and check if it sounds right. _Whom_ is in the object case and receives the action of the verb. Substitute _him_ or _them_ and check if it sounds right.\n*Example:* She knows _whom_ she should ask. Substitute, rearrange, and check: She knows she should ask _him. Him_ sounds right, so _whom_ is correct.","id":"RelPro0.4818443637419032"},{"type":"text","abbreviation":"PossPro","comment":"*Correct Possessive Pronoun:*\nThe possessive pronouns: _my, our, your, his_, _her_, _its_ and _their_ must connect to nouns. They are called _determiners_, because they determine _whom_ belongs to the noun.\n*Example:* _Your_ friend. _Your_ determines whose friend it is.\nOther possessive pronouns: _mine, ours, yours, his_, _hers_, and _theirs_ stand on their own and do not connect to nouns.\n*Example:* The pillow is _mine._\nOnly possessive pronoun determiners can also connect to a _gerund_ (a verb form ending in __ing_ that serve as a sentence subject).\n*Examples:* _His_ (not _Him_) cooking is not the best. _Their_ (not _Theirs_) housekeeping is not the best.","id":"PossPro0.6296870428896473"},{"abbreviation":"RefPro","comment":"*Correct Reflexive Pronoun:*\nReflexive pronouns end in \"self\" or \"selves\" and must refer to the subject of the sentence. These pronouns are necessary to the meaning of the sentence: _myself_, _ourselves_, _yourself_, _yourselves_, _himself_, _herself_, _itself_, and _themselves_.\n*▪* Don't use a reflexive pronoun as the object of a prepositional phrase without reference to the sentence subject.\n*Examples:* It was done by _yourself_.\n*Revision:* You did it by _yourself_.\n*▪* Don't use a reflexive pronoun as the sentence subject.\n*Examples:* Joe and _myself_ are playing cards.\n*Revision:* Joe and _I_ are playing cards.\n*▪* Don't use an object case pronoun (_me, you, him, her, it_, _us, you_, _them_) as a reflexive pronoun.\n*Example:* I got me a sandwich.\n*Revision:* I got myself a sandwich. I got a sandwich.","id":"RefPro0.13867366030443096"},{"abbreviation":"Gender","comment":"*Revise Gender Pronoun Issue:*\nMake both the pronoun and its antecedent (the word, phrase, or clause to which a pronoun refers) plural when gender (male or female) does not need to be specified.\n*Example:* _Everyone_ needs _his_ rest.\n*Revision:* _All_ need _their_ rest.","id":"Gender0.993244586960272"},{"abbreviation":"AdjOrd","comment":"*Revise Adjective Order:*\nAn adjective is placed before the noun it modifies and answers Which one? How many? or What kind? of the noun. Avoid using adjectives that do not add meaning to a sentence, such as _interesting_, _beautiful_, _nice_, and _exciting_. Multiple adjective follow the Which one? How many? or What kind? order.\n*Examples:* She saw _these_ (Which one?) _two_ (How many?) _handsome_ (What kind?) men.","id":"AdjOrd0.5987074694163634"},{"abbreviation":"PredAdj","comment":"*Correct Predicate Adjective:*\nA predicate adjectivefollows a linking verb to modify the noun or pronoun before it. Linking verbs include \"to be\" verbs: _is, am, are, was, were, be, being,_ and _been_ and other state of being verbs, such as _become_, _seem_, _look_, _feel_, _smell_, and _appear_. Don't add the __ly_ onto the end of a predicate adjective.\n*Example:* I _feel proudly_.\n*Revision:* I feel _proud_.","id":"PredAdj0.29381706389183315"},{"abbreviation":"Partcpl","comment":"*Revise Participial Phrase:*\nThis participial phrase must modify a word or phrase in a connected independent clause. An independent clause is a noun and connected verb which expresses a complete thought. A participial phrase consists of a present or past participle with related words, all serving as an adjective. A present participle is a verb ending in __ing_, and a past participle is a verb ending in __d_, __ed_, __en_ or sometimes an irregular form, such as __t_.\n*Examples:* Beaten and tired, he quit.\n*Explanation:* _Beaten and tired_ is a participial phrase and modifies _he_ in the independent clause: _he quit._","id":"Partcpl0.5307999055686801"}],"id":"Nouns, Pronouns, Adjectives0.9334052382799181"},{"type":"default","name":"Verbs","comments":[{"type":"text","abbreviation":"ProSV","comment":"*Correct Indefinite Pronoun Subject-Verb Agreement:*\nFollow these rules to match a verb to its indefinite pronoun subject:\n*▪* An indefinite singular pronoun matches a verb that ends in s.\n*Examples:* _Anybody_, _Anyone_, _Anything_, _Each_, _Either, Everybody_, _Everyone_, _Everything, Neither_, _Nobody_, _Nothing_, _No one_, _One_, _Somebody_, _Someone_, _Something seems_ loud, not _seem_ loud.\n*▪* An indefinite plural pronoun matches a verb that does not end in s.\n*Examples:* _Both_, _Few_, _Many_, _Several grow_ quickly, not _grows_ quickly.\n*▪* Indefinite number pronouns: _all_, _any_, _half_, _more_, _most_, _none_, _other_, and _some_ may be singular or plural depending upon the surrounding word clues.\n*Examples:* _None of this helps,_ but _more of these types may_ do so.","id":"ProSV0.10845773332772324"},{"abbreviation":"PstProg","comment":"*Correct Past Progressive Verb:*\nThe past progressive is a verb formthat adds an __ing_ onto the infinitive (base form of the verb) and is placed after _was_ or _were_ to describe an ongoing past action. Frequently, the word _while_ is used in connection with the past progressive.\n*Example:* I _was day-dreaming_ while you talked.","id":"PstProg0.03787039523211133"},{"abbreviation":"PrProg","comment":"*Correct Present Progressive Verb Form:*\nThe present progressive is a verb formthat adds an __ing_ onto the infinitive (base form of the verb) and is placed after _is, am,_ or _are_ to describe an ongoing action happening or existing now.\n*Example:* I _am walking_ to the store. Some verbs can't use the present progressive form: _to be_, _to belong, to care_, _to cost_, _to exist_, _to envy_, _to fear_, _to hate_, _to like_, _to love_, _to mind_, _to need_, _to owe_, _to want_.\n*Example:* I _be fearing_ it.\n*Revision:* I _fear_ it.","id":"PrProg0.6328024508209413"},{"abbreviation":"FutProg","comment":"*Correct Future Progressive Verb:*\nThe future progressive is a verb formthat adds an __ing_ onto the infinitive (base form of the verb) and is placed after a _will_ or _shall_ + _be_ to describe an ongoing action that will take place over a period of time in the future (while another action takes place) or to describe an ongoing future action that will be briefly interrupted by an action of less importance.\n*Examples:* She _will be eating_ while we play cards.We _shall be playing_ after the junior varsity.","id":"FutProg0.9562403394428862"},{"abbreviation":"PstPerf","comment":"*Correct Past Perfect Tense Verb:*\nThe past perfect is formed with _had_ + the past participle (a verb ending in __d_, __ed_, __en_ or sometimes an irregular form, such as __t_) to describe an action that was completed before a specific time or another specific action in the past.\n*Example:* They _had tried_ to compromise, until the opposition walked out.","id":"PstPerf0.7399955877391353"},{"abbreviation":"PrPerf","comment":"*Correct Present Perfect Tense Verb:*\nThe present perfect verb tense is formed with _has_ or _have_ + the past participle (a verb ending in __d_, __ed_, __en_ or sometimes an irregular form, such as __t_) and is used to describe an action that took place at some unidentified time in the past that relates to the present.\n*Example:* He _has talked_ a lot.","id":"PrPerf0.3644677498115647"},{"abbreviation":"FutPerf","comment":"*Correct Future Perfect Tense Verb:*\nThe future perfect tense is formed with _will_ or _shall_ + _have_ + a past participle (a verb ending in __d_, __ed_, __en_ or sometimes an irregular form, such as __t_) to describe an action that will be completed before a specific time or another action in the future.\n*Example:* The kids _will have practiced_ for ten years by then.\nDon't use the future perfect tense to begin clauses with _when_, _while_, _before_, _after_, _by the time_, _as soon as_, _if_, _unless_. Use the present perfect tense instead.\n*Example:* While you _will have acted_ badly, I never would\n*Revision:* While you _have acted_ badly, I never would.","id":"FutPerf0.6845505605513111"},{"abbreviation":"PstPerProg","comment":"*Correct Past Perfect Progressive Verb:*\nThe past perfect progressive form connects _had been_ + a present participle (a verb ending in __ing_) to describe a past continuous action that began in the past and continued until another time or event.\n*Example:* Because I _had_ not _been studying_, I failed.","id":"PstPerProg0.6994930810232427"},{"abbreviation":"PrPerProg","comment":"*Correct Present Perfect Progressive Verb:*\nThe present perfect progressive form connects _has_ or _have_ + _been_ to a present participle (a verb ending in __ing_) to describe an action that began in the past, continues in the present, and may continue into the future.\n*Example:* I _have been eating_.","id":"PrPerProg0.46827869667024613"},{"abbreviation":"FutPerProg","comment":"*Correct Future Perfect Progressive Verb:*\nThe future progressive form can connect _will have been_ + a present participle (a verb ending in __ing_)for an ongoing future action interrupted by another action.\n*Example:* She will have been waiting for one hour when the bus arrives.","id":"FutPerProg0.8991776866605963"},{"abbreviation":"Active","comment":"*Change to Active Voice:*\nIn the active voice, the subject performs the action of the main verb. In the passive voice, the subject receives the action. Use the active in essays and narratives unless the subject is unknown or unimportant.\n*Example:* It was said by me.\n*Revision:* I said it.","id":"Active0.7263000198856422"},{"abbreviation":"Passive","comment":"*Change to Passive Voice*\nIn the passive voice, the subject receives the action of the main verb. Use the passive voice when the subject is unknown or unimportant. Also use the passive voice in scientific writing to focus on objective data, not the sentence subject.\n*Example:* About 25% received the pill in the research group. Not... I gave the pill to about 25% of the research group.","id":"Passive0.83246332907982"},{"type":"text","abbreviation":"SubjMood","comment":"*Correct Subjunctive Mood:*\nAdverb clauses can use the subjunctive mood to express a fact, prediction, doubt, regret, or a guess.\n*▪* The subjunctive mood of the \"to be\" verb is _*were*_ in the past tense, no matter what the subject is.\n*Example:* If she were smarter, she would work harder.\n*▪* The subjunctive mood of the \"to be\" verb is _*be*_ in the present tense, no matter what the subject is.\n*Example:* His demand is that everyone be as clever as he.\n*▪* Adverb clauses can use the subjunctive mood to express a wish. For a wish about something that has not yet happened, use the past tense or _were_.\n*Example:* I wish I were able to watch.\n*▪* Adverb clauses can use the subjunctive mood to express a wish. For a wish about something that happened in the past, use the past perfect verb tense (_had_ + the past participle.\n*Example:* I wish I had seen the last episode of that show.\n*▪* Adverb clauses can also use the subjunctive mood to make a request. A request can be in the form of a favor, proposal, or demand. Use the base form of the verb, whether the subject is singular or plural.\n*Example:* I recommend that he _give_ the note back to the girl.","id":"SubjMood0.677189440318916"}],"id":"Verbs0.9568383955159077"},{"type":"default","name":"Modifiers, Adverbs, Prepositions, Conjunctions","comments":[{"abbreviation":"CompMod","comment":"*Correct Comparative Modifier:*\nA comparative modifier is an adjective or adverb that modifies two things. Follow these rules to use comparative modifiers correctly:\n*▪* Use the suffix \"_er\" for a one-syllable modifier.\n*Example:* She is _short-er_ than I.\n*▪* Use \"_er\" or _more_ (_less_) for a two-syllable modifier.\n*Example:* He seems _more help-ful_ than they.\n*▪* Use _more_ or _less_ for a three-syllable (or longer) modifier.\n*Example:* Frank was _more gen-er-ous_ than Keith.\n*Example:* Frank was _more gen-er-ous_ than Keith.\n*▪* Use _more_ or _less_ for all adverbs ending in __ly_\n*Examples:* She apologized _more con-vin-cing-ly_ than did her friend.","id":"CompMod0.5730000767120618"},{"abbreviation":"SupMod","comment":"*Correct Superlative Modifier:*\nA superlative modifier is an adjective or adverb that modifies three or more things Follow these rules to use superlative modifiers correctly:\n*▪* Use the suffix \"_est\" for a one-syllable modifier.\n*Example:* Of Rachel, Tim, and Sam, Rachel is the _smart-est_.\n*▪* Use \"_est,\" _most_, or _least_ for a two-syllable modifier.\n*Example:* Of Rachel, Tim, and Sam, Rachel has the _most tal-ent_).\n*▪* Use _most (least)_ for a three-syllable or longer modifier.\n*Example:* Of the five contestants, Jane spoke _most care-ful-ly_.","id":"SupMod0.7319039185692988"},{"type":"text","abbreviation":"MisMod","comment":"*Revise Misplaced Modifier:*\nThis modifier is misplaced. A modifier should be placed, whenever possible, next to the word it modifies (describes, identifies, defines, or limits).\n*Example:* The modifier in the following sentences is _only_: She _only_ requested two appetizers.\n*Revision:* She requested _only_ two appetizers.","id":"MisMod0.21167542034235098"},{"type":"text","abbreviation":"DangMod","comment":"*Revise Dangling Modifier:*\nRevise this dangling modifier. A dangling modifier is an adjective or adverb which is not directly connected to the subject and so creates confusion for the reader.\n*Example:* Wanted: Someone to care for an old elephant who does not smoke or drink liquor.\n*Explanation:* The modifier, \"who does not smoke or drink liquor\" is not directly connected to \"Someone\" and appears to be connected to \"an old elephant.\" Obviously, elephants do not smoke or drink liquor, but the sentence unintentionally suggests that they do.","id":"DangMod0.29726335474588783"},{"type":"text","abbreviation":"AdvOrd","comment":"*Revise Adverb Order:*\nAn adverb modifies (describes, identifies, defines, or limits) a *verb*, an *adjective*, or an *adverb* by answering How? When? Where? or What Degree? The adverb may be found before or after the word or words that it modifies (describes, identifies, defines, or limits). Follow these rules to use adverbs correctly:\n*▪* Multiple adverbs follow the How? When? Where? or What Degree? order.\n*Examples:* _Carefully_, you _soon_ may walk _where_ tigers _mostly_ roam.\n*▪* As a matter of good writing style, place shorter adverbial phrases in front of longer ones.\n*Example*: The family walks _around the block after every Thanksgiving Dinner_. Explanation: The phrase _around the block_ is shorter than _after every Thanksgiving_.\n*▪* As a matter of good writing style, place specific adverbs before general ones.\n*Example:* It should be _exactly where_ I described, _next_ to the desk, or _somewhere over there_.\n*Explanation:* The specific adverbs _exactly where_ and _next_ come before _somewhere over there_.\n*▪* Avoid overusing such adverbs as _very_ that add little meaning to a sentence.\n*Example:* That is a _very_ interesting idea.","id":"AdvOrd0.6995020849781437"},{"type":"text","abbreviation":"HyphMod","comment":"*Correct Hyphenated Modifier:*\nBoth adjectives, which modify (describe, identify, define, or limit) nouns and answer Which one? How many? or What kind?, and adverbs, which modify a *verb*, an *adjective*, or an *adverb* and answer How? When? Where? or What Degree?, may be combined with hyphens (-) to form compound modifiers.\n*▪* Use a hyphen to join a compound adjective to modify a single noun or pronoun. Don't use a hyphen if you can use the word _and_ between the two adjectives.\n*Examples:* world-famous hot dogs; warm, comfortable coat (warm and comfortable, not warm-comfortable)\n*▪* Use a hyphen to join a compound adverb when used before nouns.\n*Example*: The much-requested song.\n*▪* When the compound adverb is after the noun, don't hyphenate.\n*Example*: Her wishes were always well known.","id":"HyphMod0.05524861122711644"},{"type":"text","abbreviation":"Prep","comment":"*Revise Preposition Issue:*\nA preposition is always part of a prepositional phrase. The preposition shows a relationship between a word indicating location, position, or time and its object. The preposition asks \"What?\" or \"Whom?\" and the object follows with the answer.\n*Example:* He ran _up the road_.\n*Explanation:* The preposition, _up_, asks, \"What?\" and the object, _the road_, provides the answer. Follow these rules to use prepositions properly:\n*▪* Don't string together more than two prepositional phrases.\n*Example:* Peter Rabbit ran _through the field, under the fence, into the garden_.\n*Revision:* Peter Rabbit ran _through the field_. Afterwards, he ran _under the fence_ and _into the garden_.\n*▪* Don't add the _of_ or _on_ prepositions when unnecessary.\n*Examples:* Get off -of- my couch. Don't blame -on- me for that.\n*▪* Avoid ending sentences with awkward prepositions.\n*Example:* The cook did not know what the pie was made of.\n*Revision:* The cook did not know the ingredients in the pie.","id":"Prep0.2277366553807516"},{"abbreviation":"CoConj","comment":"*Needs Coordinating Conjunction:*\nCoordinating conjunctions join words, phrases, or clauses of equal importance.\n*Examples:* I need one _or_ two. He also brought along two water bottles, _yet_ he did not know why.\n*Memory Trick (to remember the coordinating conjunctions): FANBOYS* (For-And-Nor-But-Or-Yet-So)","id":"CoConj0.4555114810142009"},{"abbreviation":"CorConj","comment":"*Needs Correlative Conjunction:*\nCorrelative conjunctions are pairs of conjunctions which join words, phrases, or clauses. The pairs include _both-and_, _not only-but also_, _either-or_, _whether-or_, _neither-nor_.\n*Example:* Both Jake _and_ Kenny went to college.","id":"CorConj0.8098861582184467"},{"type":"text","abbreviation":"SubConj","comment":"*Needs Subordinating Conjunction:*\nA subordinating conjunction begins an adverbial clause to indicate time (_when_), cause-effect (_if_), or exception (_although_). The adverbial clause is a dependent clause (a noun and a connected verb that does not express a complete thought) that is subordinate to (of less importance than) the connected independent clause (a noun and connected verb which expresses a complete thought). The subordinating conjunction signals that dependent and subordinate position.\n*Example:* _Unless you give me permission, I will not act._\n_*Explanation:*_ _Unless signals that the rest of the clause: \"you give me permission\" is dependent upon and subordinate to the independent clause: \"I will not act.\"_\n*AAAWWUBBIS Memory Trick (to remember the subordinating conjunctions):* Most dependent clauses begin with these words: _After,_ _Although,_ _As,_ _When,_ _While,_ _Until,_ _Because,_ _Before,_ _If,_ or _Since_.","id":"SubConj0.8442993629369693"}],"id":"Modifiers, Adverbs, Prepositions, Conjunctions0.22226861149599197"},{"type":"default","name":"Punctuation, Capitalization, Quotation Rules","comments":[{"type":"text","abbreviation":"SpTagCm","comment":"*Correct Speaker Tag Comma:*\nFollow these rules for comma placement with speaker tags (the speakers and speech-related verbs) in dialogue:\n*▪* Place commas after a beginning speaker tag to the left of the quotation marks.\n*Example:* He said, \"I shouldn't listen to what you say.\"\n*▪* Place commas before and after a middle speaker tag to the left of both quotation marks.\n*Example:* \"But if you don't, he shouted \"you will never win.\"\n*▪* Place commas before an ending speaker tag to the left of the quotation marks.\n*Example:* \"Okay. I will give you another chance,\" he responded.\nQuestion marks and exclamation points are placed in the same positions as commas.","id":"SpTagCm0.107350241610084"},{"abbreviation":"DrAddCm","comment":"*Correct Direct Address Comma:*\nthese rules for comma placement with nouns of direct address (the character spoken to: a name, noun phrase, or noun clause) in dialogue:\n*▪* If the noun of direct address is placed at the beginning of the sentence, place a comma after that noun.\n*Examples:* Kristen, leave some for your sister. Officer Daniels, I need your help. Whomever you are, stop talking.\n*▪* If the noun of direct address is placed in the middle of the sentence, place commas before and after that noun.\n*Examples:* If you insist, Dad, I will. If you insist, Your Honor, I will.\n*▪* If the noun of direct address is placed at the end of the sentence, place a comma before that noun.\n*Examples:* Just leave a little bit, honey. Just leave a little bit, you selfish monster.","id":"DrAddCm0.5257217021548899"},{"type":"text","abbreviation":"AbbrCm","comment":"*Correct Commas with Abbreviations:*\nFollow these comma rules with abbreviations: Place commas before and after degree or job title, and family title, and Latin abbreviations unless the abbreviation ends the sentence.\n*▪* Educational degrees and job titles which follow peoples' last names. Job titles which precede names don't have commas.\n*Examples:* Maureen Johnson, M.D., became a medical doctor in 2019. Lacy Smith, C.E.O., was the first chief executive officer of that corporation. Sgt. O'Rourke became a sergeant and Dr. Lang became a doctor in 2018.\n*▪* Family titles which follow peoples' last names. Family titles which follow first names don't have commas.\n*Examples:* Maurice Small, IV, was listening to John Jr. and John Sr.\n*▪* Latin abbreviations\n*Example:* He likes them all: cake, cookies, etc. (means _and so on)_\n*Example:* I love ice cream, e.g., vanilla. (means _for example_)\n*Example:* He is goofy, i.e., silly. (means _that is_ or _in other words_)","id":"AbbrCm0.10128480382899863"},{"abbreviation":"SerCm","comment":"*Correct Commas in Series:*\nPlace commas after each item in lists, except the last one. Newspapers, web articles, and some magazines eliminate the last comma; however, most style manuals still require the last comma.\n*Example:* John, Jane, and Jose left early.","id":"SerCm0.5999797614648954"},{"abbreviation":"IntroCm","comment":"*Needs Introductory Word(s) Comma:*\nPlace commas after introductory words or phrases which have special emphasis. Place a comma after introductory prepositional phrases with more than four words.\n*Examples:* _First_, listen to me. _Throughout the rest of the book_, the characters do not change. _From there_ they went to the party.","id":"IntroCm0.9233749416153483"},{"type":"text","abbreviation":"GeogCm","comment":"*Correct Comma with Geography:*\nPlace commas between related geographical place names and after the last place name unless it appears the end of a sentence. When the place name is a possessive, this rule does not apply.\n*Examples:* She lived in Rome, Italy, for a year. Rome, Italy's traffic is congested.","id":"GeogCm0.2099769414548729"},{"abbreviation":"DatesCm","comment":"*Correct Comma with Dates:*\nPlace commas between the number date and its year and after the year unless it appears at the end of the sentence.\n*Example:* We left town on May 4, 1999, before the storm arrived.","id":"DatesCm0.42744203881008436"},{"type":"text","abbreviation":"AdjCm","comment":"*Correct Commas with Adjectives:*\nPlace commas to separate coordinate adjectives. Coordinate adjectives are two or more adjectives that modify a noun or pronoun in the same way. If you can add _and_ between the adjectives and reverse their order, commas must separate them.\n*Examples:* A friendly, kind man visited us.\n*Explanation:* A friendly _and_ kind man. A kind, friendly man. Both make sense, so commas are required between the coordinate adjectives.\nDon't use commas to separate cumulative adjectives. Cumulative adjectives are two or more adjectives that modify (describe) a noun or pronoun in different ways. If you can't add _and_ between the adjectives and reverse their order, don't separate them with commas.\n*Examples:* It's a big green bug.\n*Explanation:* It's a big _and_ green bug. It's a green big bug. Neither makes sense, so don't use commas between the cumulative adjectives.","id":"AdjCm0.790546604804522"},{"abbreviation":"CompCm","comment":"*Correct Comma with Compound Sentence:*\nPlace commas before coordinating conjunctions (_for, and, nor, but, or, yet, so_) to join two long independent clauses. An independent clause is a noun and connected verb which tells a complete thought. If one or both of the independent clauses is less than five words, no comma is necessary.\n*Examples:* I liked her so much, _and_ she liked me more than I thought. I love him and he loves me.\n*▪* Don't join two independent clauses with a comma. This is known as a _comma splice._\n*Example:* They say they know what they are doing, they really have no idea how to proceed. *Revision:* They say they know what they are doing, but they really have no idea how to proceed.\n*▪* Use commas before the second of the paired correlative conjunctions to join two independent clauses.\n*Example:* _Either_ he must go, _or_ you must go.","id":"CompCm0.8152598700127744"},{"abbreviation":"DepClCm","comment":"*Correct Comma with Dependent Clause:*\nA dependent clause includes a noun and connected verb, but it does not express a complete thought. Follow these rules to place commas with dependent clauses:\n*▪* If a dependent clause begins a sentence, place a comma after the clause.\n*Example:* _Even if he had tried_, he would have failed.\n*▪* If the dependent clause is in the middle of the sentence, place commas before and after the clause.\n*Example:* Jonna was sure, _though she did not know why_, I would help.\n*▪* If a dependent clause ends the sentence, don't begin with a comma.\n*Example:* I left _after she did_.\n*▪* Place commas before and after non-restrictive relative clauses. A non-restrictive relative clause begins with _which_, _who_, _whom_, or _whose_ if it simply adds information and doesn't limit the meaning of the connected independent clause (a noun and connected verb which tells a complete thought).\n*Example:* The jacket, _which mom wore yesterday_, was green.\n*▪* Don't use commas before and after restrictive relative clauses. A restrictive relative clause begins with _that_, _who_, _whom_, or _whose_ if it limits the meaning of the connected independent clause (a noun and connected verb which expresses a complete thought).\n*Example:* The student _who wins the most votes_ will be elected Student Council President.","id":"DepClCm0.9553034223414676"},{"abbreviation":"ParExpCm","comment":"*Correct Commas with Parenthetical Expression:*\nPlace commas before and after words that interrupt the flow of the sentence.\n*Examples:* The best way to see the game, _if you can afford it_, is in person.\nPlace commas to set apart _appositives_. An appositive is a noun or pronoun placed next to another noun or pronoun to identify, define, or describe it.The appositive can be a word, phrase, or clause.\n*Example:* That man, _the one with the hat_, left town quickly.","id":"ParExpCm0.7648826725587046"},{"abbreviation":"ColonCm","comment":"*Correct Colon:*\nFollow these rules to use colons properly:\n*▪* Use a colon following a noun to signal a list. Don't capitalize the first word in the list unless it is a proper noun.\n*Examples:* Bring home these items: tortillas, sugar, and milk. Text these people: James, Paul, and your mother.\n*▪* Use a colon to show a relationship between numbers.\n*Example:* At 8:02 p.m. the ratio of girls to boys at the dance was 3:1.\n*▪* Use a colon to show a relationship within titles.\n*Example:* Many people are familiar with \"_Psalm 23_\" and refer to it as \"The Lord is My Shepherd: Psalm 23.\"\n*▪* Use a colon after business letter greetings.\n*Example:* To Whom It May Concern: Thank you for your employment application.","id":"ColonCm0.8035020804742206"},{"abbreviation":"SemiCol","comment":"*Correct Semicolon:*\nUse semicolons to join independent clauses (nouns and connected verbs which express complete thoughts) with or without conjunctions.\n*Examples:* Anna showed up late; Louise didn't at all. Anna showed up late; however, Louise didn't at all.\nSemicolons combine related phrases or dependent clauses.\n*Example:* The children enjoy jumping into puddles; they love climbing trees; they also like making mud pies.","id":"SemiCol0.7605217456814206"},{"type":"text","abbreviation":"SgPossAp","comment":"*Correct Apostrophe with a Singular Possessive Noun:*\nA possessiveis a noun or pronoun that serves as an adjective to show ownership. Follow these rules to use singular possessives properly:\n*▪* When ending in an s having a /z/ sound, place an apostrophe, then an s, or simply end with an apostrophe.\n*Examples:* _Charles's_ friend or _Charles'_ friend is fun.\n*▪* A singular possessive noun can connect to gerunds(verb forms ending in __ing_ that serve as sentence subjects).\n*Example:* _Joe's cooking_ is not the best.\n*▪* Place the apostrophe before the s for singular indefinite pronouns used as possessives.\n*Examples:* Now it is _anybody's_, _everybody's_, _somebody's_, _somebody else's_, _either's_ ballgame.\n*▪* Don't use an apostrophe with a possessive pronoun (yours, his, hers, ours, yours, its, theirs).\n*Examples:* That plate is _your's_.\n*Revision:* That plate is _yours_.","id":"SgPossAp0.9471904027610956"},{"abbreviation":"PlPossAp","comment":"*Correct Apostrophe with a Plural Possessive Noun:*\nA possessiveis a noun or pronoun that serves as an adjective to show ownership. Follow these rules to use plural possessives properly.\n*▪* For a plural possessive of a singular word that doesn't end in s, place the apostrophe after the s. If the singular and plural forms are spelled differently, place the apostrophe before the s.\n*Examples:* The _girls'_ team is good, but the _women's_ team isn't.\n*▪* For a plural possessive of a singular word that does end in s, add \"es\" and then the apostrophe.\n*Example:* Our stove worked better than the _Thomases'_ stove.\n*▪* When two or more words share joint ownership, the possessive form is used only for the last word.\n*Example:* _Matt and Suzanne's_ wedding was the social event of the season.\n*▪* When two or more words are combined to show individual ownership of something, the possessive form is used for each of the words.\n*Examples:* _Linda's_, _Christie's_, and _Wendy's_ dresses were each individually designed.","id":"PlPossAp0.126684196593289"},{"abbreviation":"(Par)","comment":"*Correct Parentheses:*\nUse parentheses following words to identify, explain, or define the preceding word, phrase, or clause.\n*Examples:* That shade of lipstick (the red) goes perfectly with her hair color.\nEnding punctuation is placed outside of words or phrases within parentheses, but inside when the parenthetical remark stands on its own as a complete sentence.\n*Examples:* I want that Popsicle® (the orange one). He was crazy. (He didn't even know what day it was.)","id":"(Par)0.5292178790255835"},{"abbreviation":"Cap","comment":"*Correct Capitalization:*\nFollow these capitalization rules:\n*▪* Capitalize proper nouns: named people, places, and things (including titles). Do not capitalize an article (_a_, _an_, _the_) that is part of the noun phrase, unless it begins the phrase.\n*Examples:* _Alex the Great_ was honored (person) at _U.S. Memorial Auditorium_ (place) with the _Smith-Lee Award_ (thing).\n*▪* If the noun is hyphenated, capitalize both words before and after the hyphen when the nouns or adjectives have equal importance.\n*Example:* The Twentieth-Century was haunted by two world wars.\nHowever, don't capitalize the word after a hyphen if both words make up a single word or if the second word is a participle modifying the first word.\n*Examples:* Top Twenty Large-sized Models and English-language Arts\n*▪* Do not capitalize common nouns: unnamed people, places, things, and ideas.\n*Examples:* It takes _self-control_ (idea) for a _teenager_ (person) to drive to _school_ (place) in a _sports car_ (thing).","id":"Cap0.18232518887131866"},{"abbreviation":"Titles","comment":"*Correct Title Punctuation:*\nAs a general rule, use quotation marks before and after titles of short texts; titles which are parts of a whole; or titles of things that cannot be picked up from a desk.\n*Examples:* articles, television episodes, acts in a play, videos, short stories, reports.\nAs a general rule, use italics (if typing) for titles of long texts; titles of whole things; or titles of things that can be picked up from a desk.\n*Examples:* magazines, newspapers, long narrative poems, movies, albums, television shows, plays","id":"Titles0.8165150251324722"},{"abbreviation":"DiaQuote","comment":"*Correct Dialogue Quotation:*\nRemember that a change in speaker requires a new paragraph. Capitalize the first word in a quoted sentence. Don't capitalize the first word of a continuing quote that was interrupted by a speaker tag.\n*Examples:* She said, \"You are crazy. However,\" she paused, \"it is crazy to be in love with you.\"\nInclude quotation marks before and after the speaker's words. Place commas and periods inside (to the left) of the closing quotation marks.\n*Examples:*\n\"I think you're wrong,\" said Victor.\nSal replied, \"I know I'm right.\"\nWhen dialogue is interrupted by comments or speaker tags, and then continues in the same sentence, begin the rest of the dialogue with a lower case letter.\n*Examples:* \"I realize,\" she paused to reconsider \"that I may have been mistaken.\" \"You are crazy. However,\" she paused, \"it is crazy to be in love with you.\"","id":"DiaQuote0.33864792115152875"},{"abbreviation":"DrQuote","comment":"*Correct Direct Quotation:*\nFollow these rules for direct quotations:\n*▪* When using the exact words of an author, this is known as a _direct quotation_. Include quotation marks before and after the author's exact words. The citation of the author or title and page number are placed within parentheses following the quotation and end with a period.\n*Examples:* The author stated, \"Over 90% of Americans support the law\" (Shetler 32).\n*▪* Don't use _dropped quotations_. A dropped quotation is a direct quotation used without an introduction. Always use a signal phrase to introduce a direct quotation.\n*Signal Phrase Examples:* The author suggests (adds, argues, asserts, cites, claims, describes, discusses, emphasizes, lists illustrates, notes, observes, reports, states)\n*▪* Place question marks and exclamation points inside (to the left) of quotation marks, if part of the quoted sentence, but outside (to the right), if not.\n*Examples:* Dr. Mosely comments, \"What if the studies are proven wrong?\" (Shetler 33). Did Dr. Mosely mean \"studies are proven wrong\"? (Shetler 33).\n*▪* Colons and semicolons go outside the closing quotation marks.\n*Examples:* \"Ask not what your country can do for you. Ask what you can do for your country\" (Kennedy): these words were President John F. Kennedy's most memorable. Kennedy explained, \"We shall pay any price, bear any burden, meet any hardship, support any friend, oppose any foe to assure the survival and success of liberty\"*;* however, he continued, \"All this will not be completed within the first one hundred days\" (Kennedy).","id":"DrQuote0.45195710101273434"},{"abbreviation":"IndQuote","comment":"*Correct Indirect Quotation:*\nAn _indirect quotation_ uses the author's idea, but not the exact words, so no quotation marks are used. The paraphrase must be accurately to preserve the source's ideas. Use only your own words to paraphrase.\n*Example:* The author said that the species was endangered (Johns 45).","id":"IndQuote0.9545548937157058"},{"abbreviation":"QinQ","comment":"*Correct Quotation within a Quotation:*\nUse single quotation marks inside a quotation for a quotation or a title in quotation marks within a quotation.\n*Example:* He asked, \"What did Dr. King mean by 'free at last' in his famous speech?\"","id":"QinQ0.0077982573158303925"},{"type":"text","abbreviation":"RedQuote","comment":"*Reduce Direct Quotation:*\nThis quotation is too long and can be made more concise (brief) without changing the author's point.\n*▪* Remove words from a direct quotation by using the ellipsis (...) inside the quotation marks. Only remove information that is irrelevant (that which does not directly apply) from the quotation.\n*Example:* The author suggests that \"Rural counties... face challenges that urban counties do not\" (Abner 35).\n*▪* You may also choose to substitute an unfamiliar word with a better word choice by surrounding the new word choice with brackets.\n*Example:* The rapper sang, \"Don't talk [nonsense] if you don't wanna hear.\"\n*▪* Additionally, indicate a spelling or grammatical error by including [sic] following the error. \n*Example:* The mayor texted, \"Why don't they teach speling [sic] anymore?\"","id":"RedQuote0.6871072474252513"},{"abbreviation":"BlkQuote","comment":"*Needs Block Quote Citation:*\nFor any quotation of more than four lines, indent one-half inch from the margin and double space without quotation marks. If the quotation has more than one paragraph, indent the first line of the second paragraph an extra 1/4 inch.","id":"BlkQuote0.07573160411654012"}],"id":"Punctuation, Capitalization, Quotation Rules0.8560812232765032"},{"type":"default","name":"End Comments","comments":[{"abbreviation":"Potent","comment":"*Potential:*\nThis first draft has real potential. For your second draft, focus your revisions on ✖.","id":"Potent0.9541918449947091"},{"abbreviation":"Revise","comment":"*Revisions:*\nThe revisions on your first draft have significantly improved this second draft. You can continue to develop your writing by ✖.","id":"Revise0.7517182283292401"},{"abbreviation":"Strength","comment":"*Chief Strength:*\nThe chief strength of this writing is ✖. Use this as a model and do more of this throughout ✖.","id":"Strength0.14202249815387558"},{"abbreviation":"Connects","comment":"*Connections:*\nYou make a strong connection between ✖ and ✖. Make more of these connections to improve your writing.","id":"Connects0.17286828127399745"},{"abbreviation":"Plan","comment":"*Planning:*\nYour writing shows a tremendous amount of careful planning. My key suggestion would be ✖.","id":"Plan0.7643595856372294"},{"abbreviation":"Research","comment":"*Research:*\nYou have spent a considerable amount of time and made the effort to research this topic thoroughly. One more suggestion would be to ✖.","id":"Research0.05876015168651083"},{"abbreviation":"Original","comment":"*Originality:*\nYour writing demonstrates a significant amount of original thought. To improve your final draft, focus on ✖.","id":"Original0.8741350264185741"},{"abbreviation":"Style","comment":"*Writing Style:*\nYour writing style is consistent and original. I would suggest ✖.","id":"Style0.1747361405111738"},{"abbreviation":"Content","comment":"*Content:*\nThe content and ideas presented throughout are impressive. Consider ✖.","id":"Content0.625024595991283"},{"abbreviation":"Audience","comment":"*Audience:*\nYou have been especially considerate to your audience throughout your writing. Think about adding the following: ✖.","id":"Audience0.9590650169394894"},{"abbreviation":"Argument","comment":"*Argument:*\nYou have built a convincing argument throughout this essay to support your claim. To make your argument even more conclusive, try ✖.","id":"Argument0.4622093606006168"},{"abbreviation":"CntlIdea","comment":"*Controlling Idea:*\nYou have maintained the controlling idea of your thesis statement throughout this essay. What you need to do now is ✖.","id":"CntlIdea0.44191932071371287"},{"abbreviation":"Charact","comment":"*Characterization:*\nYour character development is creative and thorough in this story. However, ✖.","id":"Charact0.1980607760030637"},{"abbreviation":"Expos","comment":"*Exposition:*\nThe exposition (basic situation) is creatively established at the beginning of your story. To move the story along, you might consider ✖.","id":"Expos0.780538858970937"},{"abbreviation":"PlotDev","comment":"*Plot Development:*\nYour plot development includes all the essential elements of effective story-telling. For additional revision, you might ✖.","id":"PlotDev0.8041960265159784"},{"abbreviation":"Dialg","comment":"*Dialogue:*\nYour use of dialogue is authentic, and you use a variety of speaker tags. You might ✖.","id":"Dialg0.34726420925452506"},{"abbreviation":"Edit","comment":"*Edit and Complete Final Draft:*\nSpell check and ask others to edit by suggestion additions, deletions, corrections, and substitutions. Afterwards, complete your final edit, resolve the comments, click the \"Editing\" tab in the upper right corner of your Google doc and select the \"Viewing\" dropdown to re-read. If satisfied that this is your best work, share your document. I look forward to reading your final draft.","id":"Edit0.13868698045771444"}],"id":"End Comments0.746227385268835"}],"setName":"college"}